---@meta

---@class AMoviePipelineGameMode : AGameModeBase
local AMoviePipelineGameMode = {}


---@class FMovieGraphBranch
---@field BranchName FName
local FMovieGraphBranch = {}



---@class FMovieGraphEvaluatedBranchConfig
---@field NamedNodes TMap<FString, FMovieGraphEvaluatedSettingsStack>
local FMovieGraphEvaluatedBranchConfig = {}



---@class FMovieGraphEvaluatedSettingsStack
---@field NodeInstances TArray<UMovieGraphNode>
local FMovieGraphEvaluatedSettingsStack = {}



---@class FMovieGraphEvaluationContext
---@field UserContext FMovieGraphTraversalContext
---@field VisitedNodesByOwningGraph TMap<UMovieGraphConfig, FMovieGraphEvaluationContext_VisitedNodeInfo>
---@field PinBeingFollowed UMovieGraphPin
---@field SubgraphStack TArray<UMovieGraphSubgraphNode>
---@field bCircularGraphReferenceFound boolean
---@field TraversalError FText
local FMovieGraphEvaluationContext = {}



---@class FMovieGraphEvaluationContext_VisitedNodeInfo
---@field VisitedNodes TSet<UMovieGraphNode>
local FMovieGraphEvaluationContext_VisitedNodeInfo = {}



---@class FMovieGraphFilenameResolveParams
---@field RenderDataIdentifier FMovieGraphRenderDataIdentifier
---@field RootFrameNumber int32
---@field ShotFrameNumber int32
---@field RootFrameNumberRel int32
---@field ShotFrameNumberRel int32
---@field FileMetadata TMap<FString, FString>
---@field Version int32
---@field bForceRelativeFrameNumbers boolean
---@field FileNameOverride FString
---@field bEnsureAbsolutePath boolean
---@field InitializationTime FDateTime
---@field InitializationTimeOffset FTimespan
---@field ZeroPadFrameNumberCount int32
---@field FileNameFormatOverrides TMap<FString, FString>
---@field Job UMoviePipelineExecutorJob
---@field Shot UMoviePipelineExecutorShot
---@field EvaluatedConfig UMovieGraphEvaluatedConfig
---@field FrameNumberOffset int32
---@field DefaultFrameRate FFrameRate
local FMovieGraphFilenameResolveParams = {}



---@class FMovieGraphImagePreviewData
---@field Texture UTexture
---@field Identifier FMovieGraphRenderDataIdentifier
local FMovieGraphImagePreviewData = {}



---@class FMovieGraphInitConfig
---@field RendererClass TSubclassOf<UMovieGraphRendererBase>
---@field DataSourceClass TSubclassOf<UMovieGraphDataSourceBase>
---@field AudioRendererClass TSubclassOf<UMovieGraphAudioRendererBase>
---@field bRenderViewport boolean
local FMovieGraphInitConfig = {}



---@class FMovieGraphNamedResolution
---@field ProfileName FName
---@field Resolution FIntPoint
---@field Description FString
local FMovieGraphNamedResolution = {}



---@class FMovieGraphPinProperties
---@field Label FName
---@field Type EMovieGraphValueType
---@field TypeObject UObject
---@field bAllowMultipleConnections boolean
---@field bIsBranch boolean
---@field bIsBuiltIn boolean
local FMovieGraphPinProperties = {}



---@class FMovieGraphPropertyInfo
---@field Name FName
---@field bIsDynamicProperty boolean
---@field ValueType EMovieGraphValueType
---@field ValueTypeObject UObject
local FMovieGraphPropertyInfo = {}



---@class FMovieGraphRenderDataIdentifier
---@field RootBranchName FName
---@field LayerName FString
---@field RendererName FString
---@field SubResourceName FString
---@field CameraName FString
local FMovieGraphRenderDataIdentifier = {}



---@class FMovieGraphRenderLayerOutputData
---@field FilePaths TArray<FString>
local FMovieGraphRenderLayerOutputData = {}



---@class FMovieGraphRenderOutputData
---@field Shot TWeakObjectPtr<UMoviePipelineExecutorShot>
---@field RenderLayerData TMap<FMovieGraphRenderDataIdentifier, FMovieGraphRenderLayerOutputData>
local FMovieGraphRenderOutputData = {}



---@class FMovieGraphResolveArgs
---@field FilenameArguments TMap<FString, FString>
---@field FileMetadata TMap<FString, FString>
local FMovieGraphResolveArgs = {}



---@class FMovieGraphTimeStepData
---@field OutputFrameNumber int32
---@field ShotOutputFrameNumber int32
---@field RenderedFrameNumber int32
---@field FrameDeltaTime float
---@field WorldTimeDilation float
---@field WorldSeconds float
---@field MotionBlurFraction float
---@field FrameRate FFrameRate
---@field TemporalSampleIndex int32
---@field TemporalSampleCount int32
---@field bIsFirstTemporalSampleForFrame boolean
---@field bIsLastTemporalSampleForFrame boolean
---@field bDiscardOutput boolean
---@field bRequiresAccumulator boolean
---@field EvaluatedConfig UMovieGraphEvaluatedConfig
---@field RootTimeCode FTimecode
---@field RootFrameNumber FFrameNumber
---@field ShotTimeCode FTimecode
---@field ShotFrameNumber FFrameNumber
local FMovieGraphTimeStepData = {}



---@class FMovieGraphTraversalContext
---@field ShotIndex int32
---@field ShotCount int32
---@field Job UMoviePipelineExecutorJob
---@field Shot UMoviePipelineExecutorShot
---@field RootGraph UMovieGraphConfig
---@field RenderDataIdentifier FMovieGraphRenderDataIdentifier
---@field Time FMovieGraphTimeStepData
local FMovieGraphTraversalContext = {}



---@class FMovieGraphVersioningSettings
---@field bAutoVersioning boolean
---@field VersionNumber int32
local FMovieGraphVersioningSettings = {}



---@class FMoviePipelineCameraCutInfo
local FMoviePipelineCameraCutInfo = {}


---@class FMoviePipelineFilenameResolveParams
---@field FrameNumber int32
---@field FrameNumberShot int32
---@field FrameNumberRel int32
---@field FrameNumberShotRel int32
---@field CameraNameOverride FString
---@field ShotNameOverride FString
---@field ZeroPadFrameNumberCount int32
---@field bForceRelativeFrameNumbers boolean
---@field FileNameOverride FString
---@field FileNameFormatOverrides TMap<FString, FString>
---@field FileMetadata TMap<FString, FString>
---@field InitializationTime FDateTime
---@field InitializationTimeOffset FTimespan
---@field InitializationVersion int32
---@field Job UMoviePipelineExecutorJob
---@field ShotOverride UMoviePipelineExecutorShot
---@field AdditionalFrameNumberOffset int32
local FMoviePipelineFilenameResolveParams = {}



---@class FMoviePipelineFormatArgs
---@field FilenameArguments TMap<FString, FString>
---@field FileMetadata TMap<FString, FString>
---@field InJob UMoviePipelineExecutorJob
local FMoviePipelineFormatArgs = {}



---@class FMoviePipelineOutputData
---@field Pipeline UMoviePipelineBase
---@field Job UMoviePipelineExecutorJob
---@field bSuccess boolean
---@field ShotData TArray<FMoviePipelineShotOutputData>
---@field GraphData TArray<FMovieGraphRenderOutputData>
local FMoviePipelineOutputData = {}



---@class FMoviePipelinePassIdentifier
---@field Name FString
---@field CameraName FString
local FMoviePipelinePassIdentifier = {}



---@class FMoviePipelineRenderPassOutputData
---@field FilePaths TArray<FString>
local FMoviePipelineRenderPassOutputData = {}



---@class FMoviePipelineSegmentWorkMetrics
---@field SegmentName FString
---@field OutputFrameIndex int32
---@field TotalOutputFrameCount int32
---@field OutputSubSampleIndex int32
---@field TotalSubSampleCount int32
---@field EngineWarmUpFrameIndex int32
---@field TotalEngineWarmUpFrameCount int32
local FMoviePipelineSegmentWorkMetrics = {}



---@class FMoviePipelineShotOutputData
---@field Shot TWeakObjectPtr<UMoviePipelineExecutorShot>
---@field RenderPassData TMap<FMoviePipelinePassIdentifier, FMoviePipelineRenderPassOutputData>
local FMoviePipelineShotOutputData = {}



---@class FMoviePipelineSidecarCamera
---@field BindingID FGuid
---@field Name FString
local FMoviePipelineSidecarCamera = {}



---@class IMovieGraphPostRenderNode : IInterface
local IMovieGraphPostRenderNode = {}


---@class IMovieGraphTraversableObject : IInterface
local IMovieGraphTraversableObject = {}


---@class UMovieGraphApplyCVarPresetNode : UMovieGraphSettingNode
---@field bOverride_ConsoleVariablePreset boolean
---@field ConsoleVariablePreset TScriptInterface<IMovieSceneConsoleVariableTrackInterface>
local UMovieGraphApplyCVarPresetNode = {}



---@class UMovieGraphAudioOutputNode : UMovieGraphFileOutputNode
local UMovieGraphAudioOutputNode = {}


---@class UMovieGraphAudioRendererBase : UObject
local UMovieGraphAudioRendererBase = {}


---@class UMovieGraphBlueprintLibrary : UBlueprintFunctionLibrary
local UMovieGraphBlueprintLibrary = {}

---@param InParams FMovieGraphFilenameResolveParams
---@param bGetNextVersion boolean
---@return int32
function UMovieGraphBlueprintLibrary:ResolveVersionNumber(InParams, bGetNextVersion) end
---@param InFormatString FString
---@param InParams FMovieGraphFilenameResolveParams
---@param OutMergedFormatArgs FMovieGraphResolveArgs
---@return FString
function UMovieGraphBlueprintLibrary:ResolveFilenameFormatArguments(InFormatString, InParams, OutMergedFormatArgs) end
---@param InResX int32
---@param InResY int32
---@return FMovieGraphNamedResolution
function UMovieGraphBlueprintLibrary:NamedResolutionFromSize(InResX, InResY) end
---@param InResolutionProfileName FName
---@return FMovieGraphNamedResolution
function UMovieGraphBlueprintLibrary:NamedResolutionFromProfile(InResolutionProfileName) end
---@param InResolutionProfileName FName
---@return boolean
function UMovieGraphBlueprintLibrary:IsNamedResolutionValid(InResolutionProfileName) end
---@param InMovieGraphPipeline UMovieGraphPipeline
---@return FTimecode
function UMovieGraphBlueprintLibrary:GetRootTimecode(InMovieGraphPipeline) end
---@param InMovieGraphPipeline UMovieGraphPipeline
---@return FFrameNumber
function UMovieGraphBlueprintLibrary:GetRootFrameNumber(InMovieGraphPipeline) end
---@param InMovieGraphPipeline UMovieGraphPipeline
---@return EMovieRenderPipelineState
function UMovieGraphBlueprintLibrary:GetPipelineState(InMovieGraphPipeline) end
---@param InMovieGraphPipeline UMovieGraphPipeline
---@param OutCurrentIndex int32
---@param OutTotalCount int32
function UMovieGraphBlueprintLibrary:GetOverallSegmentCounts(InMovieGraphPipeline, OutCurrentIndex, OutTotalCount) end
---@param InMovieGraphPipeline UMovieGraphPipeline
---@param OutCurrentIndex int32
---@param OutTotalCount int32
function UMovieGraphBlueprintLibrary:GetOverallOutputFrames(InMovieGraphPipeline, OutCurrentIndex, OutTotalCount) end
---@param InMovieGraphPipeline UMovieGraphPipeline
---@return FText
function UMovieGraphBlueprintLibrary:GetJobName(InMovieGraphPipeline) end
---@param InMovieGraphPipeline UMovieGraphPipeline
---@return FDateTime
function UMovieGraphBlueprintLibrary:GetJobInitializationTime(InMovieGraphPipeline) end
---@param InMovieGraphPipeline UMovieGraphPipeline
---@return FText
function UMovieGraphBlueprintLibrary:GetJobAuthor(InMovieGraphPipeline) end
---@param InMovieGraphPipeline UMovieGraphPipeline
---@param OutEstimate FTimespan
---@return boolean
function UMovieGraphBlueprintLibrary:GetEstimatedTimeRemaining(InMovieGraphPipeline, OutEstimate) end
---@param InEvaluatedGraph UMovieGraphEvaluatedConfig
---@return FIntPoint
function UMovieGraphBlueprintLibrary:GetEffectiveOutputResolution(InEvaluatedGraph) end
---@param InNode UMovieGraphGlobalOutputSettingNode
---@param InDefaultRate FFrameRate
---@return FFrameRate
function UMovieGraphBlueprintLibrary:GetEffectiveFrameRate(InNode, InDefaultRate) end
---@param InMovieGraphPipeline UMovieGraphPipeline
---@return FTimecode
function UMovieGraphBlueprintLibrary:GetCurrentShotTimecode(InMovieGraphPipeline) end
---@param InMovieGraphPipeline UMovieGraphPipeline
---@return FFrameNumber
function UMovieGraphBlueprintLibrary:GetCurrentShotFrameNumber(InMovieGraphPipeline) end
---@param InMovieGraphPipeline UMovieGraphPipeline
---@return FMoviePipelineSegmentWorkMetrics
function UMovieGraphBlueprintLibrary:GetCurrentSegmentWorkMetrics(InMovieGraphPipeline) end
---@param InMovieGraphPipeline UMovieGraphPipeline
---@return EMovieRenderShotState
function UMovieGraphBlueprintLibrary:GetCurrentSegmentState(InMovieGraphPipeline) end
---@param InMovieGraphPipeline UMovieGraphPipeline
---@param OutOuterName FText
---@param OutInnerName FText
function UMovieGraphBlueprintLibrary:GetCurrentSegmentName(InMovieGraphPipeline, OutOuterName, OutInnerName) end
---@param InMovieGraphPipeline UMovieGraphPipeline
---@return float
function UMovieGraphBlueprintLibrary:GetCurrentFocusDistance(InMovieGraphPipeline) end
---@param InMovieGraphPipeline UMovieGraphPipeline
---@return float
function UMovieGraphBlueprintLibrary:GetCurrentFocalLength(InMovieGraphPipeline) end
---@param InMovieGraphPipeline UMovieGraphPipeline
---@return UCineCameraComponent
function UMovieGraphBlueprintLibrary:GetCurrentCineCamera(InMovieGraphPipeline) end
---@param InMovieGraphPipeline UMovieGraphPipeline
---@return float
function UMovieGraphBlueprintLibrary:GetCurrentAperture(InMovieGraphPipeline) end
---@param InPipeline UMovieGraphPipeline
---@return float
function UMovieGraphBlueprintLibrary:GetCompletionPercentage(InPipeline) end


---@class UMovieGraphBranchNode : UMovieGraphNode
local UMovieGraphBranchNode = {}


---@class UMovieGraphBurnInNode : UMovieGraphWidgetRendererBaseNode
---@field bOverride_BurnInClass boolean
---@field BurnInClass FSoftClassPath
---@field BurnInWidgetInstances TMap<UClass, UMovieGraphBurnInWidget>
local UMovieGraphBurnInNode = {}



---@class UMovieGraphBurnInWidget : UUserWidget
local UMovieGraphBurnInWidget = {}

---@param InGraphPipeline UMovieGraphPipeline
---@param InEvaluatedConfig UMovieGraphEvaluatedConfig
function UMovieGraphBurnInWidget:UpdateForGraph(InGraphPipeline, InEvaluatedConfig) end


---@class UMovieGraphCameraSettingNode : UMovieGraphSettingNode
---@field bOverride_ShutterTiming boolean
---@field bOverride_OverscanPercentage boolean
---@field ShutterTiming EMoviePipelineShutterTiming
---@field OverscanPercentage float
local UMovieGraphCameraSettingNode = {}



---@class UMovieGraphCollection : UObject
---@field CollectionName FString
---@field ConditionGroups TArray<UMovieGraphConditionGroup>
local UMovieGraphCollection = {}

---@param InName FString
function UMovieGraphCollection:SetCollectionName(InName) end
---@param InConditionGroup UMovieGraphConditionGroup
---@return boolean
function UMovieGraphCollection:RemoveConditionGroup(InConditionGroup) end
---@param InConditionGroup UMovieGraphConditionGroup
---@param NewIndex int32
---@return boolean
function UMovieGraphCollection:MoveConditionGroupToIndex(InConditionGroup, NewIndex) end
---@return TArray<UMovieGraphConditionGroup>
function UMovieGraphCollection:GetConditionGroups() end
---@return FString
function UMovieGraphCollection:GetCollectionName() end
---@param InWorld UWorld
---@return TSet<AActor>
function UMovieGraphCollection:Evaluate(InWorld) end
---@return UMovieGraphConditionGroup
function UMovieGraphCollection:AddConditionGroup() end


---@class UMovieGraphCollectionModifier : UObject
---@field Collections TArray<UMovieGraphCollection>
local UMovieGraphCollectionModifier = {}

---@param InCollections TArray<UMovieGraphCollection>
function UMovieGraphCollectionModifier:SetCollections(InCollections) end
---@return TArray<UMovieGraphCollection>
function UMovieGraphCollectionModifier:GetCollections() end
---@param Collection UMovieGraphCollection
function UMovieGraphCollectionModifier:AddCollection(Collection) end


---@class UMovieGraphCollectionNode : UMovieGraphSettingNode
---@field bOverride_Collection boolean
---@field Collection UMovieGraphCollection
local UMovieGraphCollectionNode = {}



---@class UMovieGraphCommandLineEncoderNode : UMovieGraphSettingNode
---@field bOverride_FileNameFormat boolean
---@field bOverride_bDeleteSourceFiles boolean
---@field bOverride_bSkipEncodeOnRenderCanceled boolean
---@field bOverride_VideoCodec boolean
---@field bOverride_AudioCodec boolean
---@field bOverride_OutputFileExtension boolean
---@field bOverride_CommandLineFormat boolean
---@field bOverride_VideoInputStringFormat boolean
---@field bOverride_AudioInputStringFormat boolean
---@field bOverride_EncodeSettings boolean
---@field bOverride_bRetainInputTextFiles boolean
---@field FileNameFormat FString
---@field bDeleteSourceFiles boolean
---@field bSkipEncodeOnRenderCanceled boolean
---@field VideoCodec FString
---@field AudioCodec FString
---@field OutputFileExtension FString
---@field CommandLineFormat FString
---@field VideoInputStringFormat FString
---@field AudioInputStringFormat FString
---@field EncodeSettings FString
---@field bRetainInputTextFiles boolean
local UMovieGraphCommandLineEncoderNode = {}



---@class UMovieGraphConditionGroup : UObject
---@field ID FGuid
---@field OpType EMovieGraphConditionGroupOpType
---@field Queries TArray<UMovieGraphConditionGroupQueryBase>
---@field QueryResult TSet<AActor>
---@field EvaluationResult TSet<AActor>
local UMovieGraphConditionGroup = {}

---@param OperationType EMovieGraphConditionGroupOpType
function UMovieGraphConditionGroup:SetOperationType(OperationType) end
---@param InQuery UMovieGraphConditionGroupQueryBase
---@return boolean
function UMovieGraphConditionGroup:RemoveQuery(InQuery) end
---@param InQuery UMovieGraphConditionGroupQueryBase
---@param NewIndex int32
---@return boolean
function UMovieGraphConditionGroup:MoveQueryToIndex(InQuery, NewIndex) end
---@return boolean
function UMovieGraphConditionGroup:IsFirstConditionGroup() end
---@return TArray<UMovieGraphConditionGroupQueryBase>
function UMovieGraphConditionGroup:GetQueries() end
---@return EMovieGraphConditionGroupOpType
function UMovieGraphConditionGroup:GetOperationType() end
---@param InWorld UWorld
---@return TSet<AActor>
function UMovieGraphConditionGroup:Evaluate(InWorld) end
---@param InQueryType TSubclassOf<UMovieGraphConditionGroupQueryBase>
---@param InsertIndex int32
---@return UMovieGraphConditionGroupQueryBase
function UMovieGraphConditionGroup:AddQuery(InQueryType, InsertIndex) end


---@class UMovieGraphConditionGroupQueryBase : UObject
---@field OpType EMovieGraphConditionGroupQueryOpType
---@field bIsEnabled boolean
local UMovieGraphConditionGroupQueryBase = {}

---@return boolean
function UMovieGraphConditionGroupQueryBase:ShouldHidePropertyNames() end
---@param OperationType EMovieGraphConditionGroupQueryOpType
function UMovieGraphConditionGroupQueryBase:SetOperationType(OperationType) end
---@param bEnabled boolean
function UMovieGraphConditionGroupQueryBase:SetEnabled(bEnabled) end
---@return boolean
function UMovieGraphConditionGroupQueryBase:IsFirstConditionGroupQuery() end
---@return boolean
function UMovieGraphConditionGroupQueryBase:IsEnabled() end
---@return boolean
function UMovieGraphConditionGroupQueryBase:IsEditorOnlyQuery() end
---@return EMovieGraphConditionGroupQueryOpType
function UMovieGraphConditionGroupQueryBase:GetOperationType() end
---@param InActorsToQuery TArray<AActor>
---@param InWorld UWorld
---@param OutMatchingActors TSet<AActor>
function UMovieGraphConditionGroupQueryBase:Evaluate(InActorsToQuery, InWorld, OutMatchingActors) end


---@class UMovieGraphConditionGroupQuery_Actor : UMovieGraphConditionGroupQueryBase
---@field ActorsToMatch TArray<TSoftObjectPtr<AActor>>
local UMovieGraphConditionGroupQuery_Actor = {}



---@class UMovieGraphConditionGroupQuery_ActorName : UMovieGraphConditionGroupQueryBase
---@field WildcardSearch FString
local UMovieGraphConditionGroupQuery_ActorName = {}



---@class UMovieGraphConditionGroupQuery_ActorTagName : UMovieGraphConditionGroupQueryBase
---@field TagsToMatch FString
local UMovieGraphConditionGroupQuery_ActorTagName = {}



---@class UMovieGraphConditionGroupQuery_ActorType : UMovieGraphConditionGroupQueryBase
---@field ActorTypes TArray<UClass>
local UMovieGraphConditionGroupQuery_ActorType = {}



---@class UMovieGraphConditionGroupQuery_ComponentTagName : UMovieGraphConditionGroupQueryBase
---@field TagsToMatch FString
local UMovieGraphConditionGroupQuery_ComponentTagName = {}



---@class UMovieGraphConditionGroupQuery_ComponentType : UMovieGraphConditionGroupQueryBase
---@field ComponentTypes TArray<UClass>
local UMovieGraphConditionGroupQuery_ComponentType = {}



---@class UMovieGraphConditionGroupQuery_EditorFolder : UMovieGraphConditionGroupQueryBase
---@field FolderPaths TArray<FName>
local UMovieGraphConditionGroupQuery_EditorFolder = {}



---@class UMovieGraphConditionGroupQuery_Sublevel : UMovieGraphConditionGroupQueryBase
---@field Sublevels TArray<TSoftObjectPtr<UWorld>>
local UMovieGraphConditionGroupQuery_Sublevel = {}



---@class UMovieGraphConfig : UObject
---@field AllNodes TArray<UMovieGraphNode>
---@field InputNode UMovieGraphNode
---@field OutputNode UMovieGraphNode
---@field Variables TArray<UMovieGraphVariable>
---@field GlobalVariables TArray<UMovieGraphGlobalVariable>
---@field Inputs TArray<UMovieGraphInput>
---@field Outputs TArray<UMovieGraphOutput>
local UMovieGraphConfig = {}

---@param InPipeline UMovieGraphPipeline
function UMovieGraphConfig:UpdateGlobalVariableValues(InPipeline) end
---@param InNode UMovieGraphNode
---@param InPinName FName
---@return boolean
function UMovieGraphConfig:RemoveOutboundEdges(InNode, InPinName) end
---@param InNodes TArray<UMovieGraphNode>
---@return boolean
function UMovieGraphConfig:RemoveNodes(InNodes) end
---@param InNode UMovieGraphNode
---@return boolean
function UMovieGraphConfig:RemoveNode(InNode) end
---@param FromNode UMovieGraphNode
---@param FromPinName FName
---@param ToNode UMovieGraphNode
---@param ToPinName FName
---@return boolean
function UMovieGraphConfig:RemoveLabeledEdge(FromNode, FromPinName, ToNode, ToPinName) end
---@param InNode UMovieGraphNode
---@param InPinName FName
---@return boolean
function UMovieGraphConfig:RemoveInboundEdges(InNode, InPinName) end
---@param InNode UMovieGraphNode
---@return boolean
function UMovieGraphConfig:RemoveAllOutboundEdges(InNode) end
---@param InNode UMovieGraphNode
---@return boolean
function UMovieGraphConfig:RemoveAllInboundEdges(InNode) end
---@param bIncludeGlobal boolean
---@return TArray<UMovieGraphVariable>
function UMovieGraphConfig:GetVariables(bIncludeGlobal) end
---@return TArray<UMovieGraphOutput>
function UMovieGraphConfig:GetOutputs() end
---@return UMovieGraphNode
function UMovieGraphConfig:GetOutputNode() end
---@return TArray<UMovieGraphInput>
function UMovieGraphConfig:GetInputs() end
---@return UMovieGraphNode
function UMovieGraphConfig:GetInputNode() end
---@param MemberToDelete UMovieGraphMember
---@return boolean
function UMovieGraphConfig:DeleteMember(MemberToDelete) end
---@param InClass TSubclassOf<UMovieGraphNode>
---@return UMovieGraphNode
function UMovieGraphConfig:CreateNodeByClass(InClass) end
---@param InContext FMovieGraphTraversalContext
---@param OutError FString
---@return UMovieGraphEvaluatedConfig
function UMovieGraphConfig:CreateFlattenedGraph(InContext, OutError) end
---@param InCustomBaseName FName
---@return UMovieGraphVariable
function UMovieGraphConfig:AddVariable(InCustomBaseName) end
---@return UMovieGraphOutput
function UMovieGraphConfig:AddOutput() end
---@param FromNode UMovieGraphNode
---@param FromPinLabel FName
---@param ToNode UMovieGraphNode
---@param ToPinLabel FName
---@return boolean
function UMovieGraphConfig:AddLabeledEdge(FromNode, FromPinLabel, ToNode, ToPinLabel) end
---@return UMovieGraphInput
function UMovieGraphConfig:AddInput() end


---@class UMovieGraphCoreTimeStep : UMovieGraphTimeStepBase
---@field CurrentTimeStepData FMovieGraphTimeStepData
local UMovieGraphCoreTimeStep = {}



---@class UMovieGraphDataSourceBase : UObject
local UMovieGraphDataSourceBase = {}


---@class UMovieGraphDebugSettingNode : UMovieGraphSettingNode
---@field bOverride_bCaptureFramesWithRenderDoc boolean
---@field bOverride_bCaptureUnrealInsightsTrace boolean
---@field bOverride_UnrealInsightsTraceFileNameFormat boolean
---@field bCaptureFramesWithRenderDoc boolean
---@field bCaptureUnrealInsightsTrace boolean
---@field UnrealInsightsTraceFileNameFormat FString
local UMovieGraphDebugSettingNode = {}



---@class UMovieGraphDefaultAudioRenderer : UMovieGraphAudioRendererBase
local UMovieGraphDefaultAudioRenderer = {}


---@class UMovieGraphDefaultRenderer : UMovieGraphRendererBase
---@field RenderPassesInUse TArray<UMovieGraphRenderPassNode>
local UMovieGraphDefaultRenderer = {}



---@class UMovieGraphEdge : UObject
---@field InputPin UMovieGraphPin
---@field OutputPin UMovieGraphPin
local UMovieGraphEdge = {}



---@class UMovieGraphEngineTimeStep : UEngineCustomTimeStep
local UMovieGraphEngineTimeStep = {}


---@class UMovieGraphEvaluatedConfig : UObject
---@field BranchConfigMapping TMap<FName, FMovieGraphEvaluatedBranchConfig>
local UMovieGraphEvaluatedConfig = {}

---@param InClass UClass
---@param InBranchName FName
---@param bIncludeCDOs boolean
---@param bExactMatch boolean
---@return TArray<UMovieGraphSettingNode>
function UMovieGraphEvaluatedConfig:GetSettingsForBranch(InClass, InBranchName, bIncludeCDOs, bExactMatch) end
---@param InClass UClass
---@param InBranchName FName
---@param bIncludeCDOs boolean
---@param bExactMatch boolean
---@return UMovieGraphSettingNode
function UMovieGraphEvaluatedConfig:GetSettingForBranch(InClass, InBranchName, bIncludeCDOs, bExactMatch) end
---@return TArray<FName>
function UMovieGraphEvaluatedConfig:GetBranchNames() end


---@class UMovieGraphExecuteScriptNode : UMovieGraphSettingNode
---@field bOverride_Script boolean
---@field Script FSoftClassPath
local UMovieGraphExecuteScriptNode = {}



---@class UMovieGraphFileOutputNode : UMovieGraphSettingNode
---@field bOverride_FileNameFormat boolean
---@field FileNameFormat FString
local UMovieGraphFileOutputNode = {}



---@class UMovieGraphGlobalGameOverridesNode : UMovieGraphSettingNode
---@field bOverride_GameModeOverride boolean
---@field bOverride_ScalabilityQualityLevel boolean
---@field bOverride_bDisableTextureStreaming boolean
---@field bOverride_bDisableLODs boolean
---@field bOverride_bDisableHLODs boolean
---@field bOverride_bFlushLevelStreaming boolean
---@field bOverride_bFlushAssetCompiler boolean
---@field bOverride_bFlushShaderCompiler boolean
---@field bOverride_bFlushGrassStreaming boolean
---@field bOverride_bFlushStreamingManagers boolean
---@field bOverride_VirtualTextureFeedbackFactor boolean
---@field GameModeOverride TSubclassOf<AGameModeBase>
---@field ScalabilityQualityLevel EMovieGraphScalabilityQualityLevel
---@field bDisableTextureStreaming boolean
---@field bDisableLODs boolean
---@field bDisableHLODs boolean
---@field bFlushLevelStreaming boolean
---@field bFlushAssetCompiler boolean
---@field bFlushShaderCompiler boolean
---@field bFlushGrassStreaming boolean
---@field bFlushStreamingManagers boolean
---@field VirtualTextureFeedbackFactor int32
local UMovieGraphGlobalGameOverridesNode = {}



---@class UMovieGraphGlobalOutputSettingNode : UMovieGraphSettingNode
---@field bOverride_OutputDirectory boolean
---@field bOverride_OutputResolution boolean
---@field bOverride_OutputFrameRate boolean
---@field bOverride_bOverwriteExistingOutput boolean
---@field bOverride_ZeroPadFrameNumbers boolean
---@field bOverride_FrameNumberOffset boolean
---@field bOverride_HandleFrameCount boolean
---@field bOverride_CustomPlaybackRangeStartFrame boolean
---@field bOverride_CustomPlaybackRangeEndFrame boolean
---@field bOverride_VersioningSettings boolean
---@field bOverride_bFlushDiskWritesPerShot boolean
---@field OutputDirectory FDirectoryPath
---@field OutputResolution FMovieGraphNamedResolution
---@field OutputFrameRate FFrameRate
---@field bOverwriteExistingOutput boolean
---@field ZeroPadFrameNumbers int32
---@field FrameNumberOffset int32
---@field HandleFrameCount int32
---@field CustomPlaybackRangeStartFrame int32
---@field CustomPlaybackRangeEndFrame int32
---@field VersioningSettings FMovieGraphVersioningSettings
---@field bFlushDiskWritesPerShot boolean
local UMovieGraphGlobalOutputSettingNode = {}



---@class UMovieGraphGlobalVariable : UMovieGraphVariable
local UMovieGraphGlobalVariable = {}


---@class UMovieGraphGlobalVariable_CameraName : UMovieGraphGlobalVariable
local UMovieGraphGlobalVariable_CameraName = {}


---@class UMovieGraphGlobalVariable_FrameNumber : UMovieGraphGlobalVariable
local UMovieGraphGlobalVariable_FrameNumber = {}


---@class UMovieGraphGlobalVariable_SequenceName : UMovieGraphGlobalVariable
local UMovieGraphGlobalVariable_SequenceName = {}


---@class UMovieGraphGlobalVariable_ShotName : UMovieGraphGlobalVariable
local UMovieGraphGlobalVariable_ShotName = {}


---@class UMovieGraphInput : UMovieGraphInterfaceBase
local UMovieGraphInput = {}


---@class UMovieGraphInputNode : UMovieGraphNode
local UMovieGraphInputNode = {}


---@class UMovieGraphInterfaceBase : UMovieGraphMember
---@field bIsBranch boolean
local UMovieGraphInterfaceBase = {}



---@class UMovieGraphLinearTimeStep : UMovieGraphCoreTimeStep
local UMovieGraphLinearTimeStep = {}


---@class UMovieGraphMaterialModifier : UMovieGraphCollectionModifier
---@field bOverride_Material boolean
---@field Material TSoftObjectPtr<UMaterialInterface>
local UMovieGraphMaterialModifier = {}

function UMovieGraphMaterialModifier:UndoModifier() end
---@param InMaterial TSoftObjectPtr<UMaterialInterface>
function UMovieGraphMaterialModifier:SetMaterial(InMaterial) end
---@param World UWorld
function UMovieGraphMaterialModifier:ApplyModifier(World) end


---@class UMovieGraphMember : UMovieGraphValueContainer
---@field Description FString
---@field Name FString
---@field Guid FGuid
---@field bIsEditable boolean
local UMovieGraphMember = {}

---@param InNewName FString
---@return boolean
function UMovieGraphMember:SetMemberName(InNewName) end
---@return FString
function UMovieGraphMember:GetMemberName() end
---@return FGuid
function UMovieGraphMember:GetGuid() end


---@class UMovieGraphMergeableModifierContainer : UObject
---@field Modifiers TArray<UMovieGraphCollectionModifier>
local UMovieGraphMergeableModifierContainer = {}



---@class UMovieGraphModifierNode : UMovieGraphSettingNode
---@field bOverride_ModifierName boolean
---@field ModifierName FString
---@field bOverride_Collections boolean
---@field bOverride_ModifiersContainer boolean
---@field Collections TArray<FName>
---@field ModifiersContainer UMovieGraphMergeableModifierContainer
local UMovieGraphModifierNode = {}

---@param ModifierType TSubclassOf<UMovieGraphCollectionModifier>
---@return boolean
function UMovieGraphModifierNode:RemoveModifier(ModifierType) end
---@param InCollectionName FName
---@return boolean
function UMovieGraphModifierNode:RemoveCollection(InCollectionName) end
---@return TArray<UMovieGraphCollectionModifier>
function UMovieGraphModifierNode:GetModifiers() end
---@param ModifierType TSubclassOf<UMovieGraphCollectionModifier>
---@return UMovieGraphCollectionModifier
function UMovieGraphModifierNode:GetModifier(ModifierType) end
---@return TArray<FName>
function UMovieGraphModifierNode:GetCollections() end
---@param ModifierType TSubclassOf<UMovieGraphCollectionModifier>
---@return UMovieGraphCollectionModifier
function UMovieGraphModifierNode:AddModifier(ModifierType) end
---@param InCollectionName FName
function UMovieGraphModifierNode:AddCollection(InCollectionName) end


---@class UMovieGraphNode : UObject
---@field InputPins TArray<UMovieGraphPin>
---@field OutputPins TArray<UMovieGraphPin>
---@field DynamicProperties FInstancedPropertyBag
---@field ExposedPropertyInfo TArray<FMovieGraphPropertyInfo>
---@field bIsDisabled boolean
---@field Guid FGuid
local UMovieGraphNode = {}

---@param PropertyName FName
function UMovieGraphNode:TogglePromotePropertyToPin(PropertyName) end
---@param InPinLabel FName
---@return UMovieGraphPin
function UMovieGraphNode:GetOutputPin(InPinLabel) end
---@param InPinLabel FName
---@param PinRequirement EMovieGraphPinQueryRequirement
---@return UMovieGraphPin
function UMovieGraphNode:GetInputPin(InPinLabel, PinRequirement) end
---@return TArray<FMovieGraphPropertyInfo>
function UMovieGraphNode:GetExposedProperties() end


---@class UMovieGraphOutput : UMovieGraphInterfaceBase
local UMovieGraphOutput = {}


---@class UMovieGraphOutputNode : UMovieGraphNode
local UMovieGraphOutputNode = {}


---@class UMovieGraphPin : UObject
---@field Node UMovieGraphNode
---@field Properties FMovieGraphPinProperties
---@field Edges TArray<UMovieGraphEdge>
local UMovieGraphPin = {}

---@return TArray<UMovieGraphNode>
function UMovieGraphPin:GetConnectedNodes() end


---@class UMovieGraphPipeline : UMoviePipelineBase
---@field GraphTimeStepInstances TArray<UMovieGraphTimeStepBase>
---@field PendingTimeStepInstance UMovieGraphTimeStepBase
---@field GraphTimeStepInstance UMovieGraphTimeStepBase
---@field GraphRendererInstance UMovieGraphRendererBase
---@field GraphDataSourceInstance UMovieGraphDataSourceBase
---@field GraphAudioRendererInstance UMovieGraphAudioRendererBase
---@field PostRenderEvaluatedGraph UMovieGraphEvaluatedConfig
---@field CurrentJob UMoviePipelineExecutorJob
---@field CurrentJobDuplicate UMoviePipelineExecutorJob
---@field ActiveShotList TArray<UMoviePipelineExecutorShot>
---@field PreviewWidgetClassToUse TSubclassOf<UMovieGraphRenderPreviewWidget>
---@field PreviewWidget UMovieGraphRenderPreviewWidget
---@field CurrentScriptInstances TArray<UMovieGraphScriptBase>
---@field OutputNodesDataSentTo TSet<UMovieGraphFileOutputNode>
---@field CustomEngineTimeStep UMovieGraphEngineTimeStep
---@field PrevCustomEngineTimeStep UEngineCustomTimeStep
local UMovieGraphPipeline = {}

---@param InDateTime FDateTime
function UMovieGraphPipeline:SetInitializationTime(InDateTime) end
function UMovieGraphPipeline:OnMoviePipelineFinishedImpl() end
---@param InJob UMoviePipelineExecutorJob
---@param InitConfig FMovieGraphInitConfig
function UMovieGraphPipeline:Initialize(InJob, InitConfig) end
---@return UMovieGraphTimeStepBase
function UMovieGraphPipeline:GetTimeStepInstance() end
---@return UMovieGraphRendererBase
function UMovieGraphPipeline:GetRendererInstance() end
---@return FTimespan
function UMovieGraphPipeline:GetInitializationTimeOffset() end
---@return FDateTime
function UMovieGraphPipeline:GetInitializationTime() end
---@param bForShot boolean
---@return FMovieGraphTraversalContext
function UMovieGraphPipeline:GetCurrentTraversalContext(bForShot) end
---@return UMoviePipelineExecutorJob
function UMovieGraphPipeline:GetCurrentJob() end


---@class UMovieGraphProjectSettings : UDeveloperSettings
---@field DefaultNamedResolutions TArray<FMovieGraphNamedResolution>
local UMovieGraphProjectSettings = {}



---@class UMovieGraphRemoveRenderSettingNode : UMovieGraphNode
---@field NodeType TSubclassOf<UMovieGraphSettingNode>
local UMovieGraphRemoveRenderSettingNode = {}



---@class UMovieGraphRenderLayer : UObject
---@field RenderLayerName FName
---@field Modifiers TArray<UMovieGraphCollectionModifier>
local UMovieGraphRenderLayer = {}

---@param NewName FName
function UMovieGraphRenderLayer:SetRenderLayerName(NewName) end
function UMovieGraphRenderLayer:Revert() end
---@param Modifier UMovieGraphCollectionModifier
function UMovieGraphRenderLayer:RemoveModifier(Modifier) end
---@return FName
function UMovieGraphRenderLayer:GetRenderLayerName() end
---@return TArray<UMovieGraphCollectionModifier>
function UMovieGraphRenderLayer:GetModifiers() end
---@param Name FString
---@return UMovieGraphCollection
function UMovieGraphRenderLayer:GetCollectionByName(Name) end
---@param World UWorld
function UMovieGraphRenderLayer:Apply(World) end
---@param Modifier UMovieGraphCollectionModifier
function UMovieGraphRenderLayer:AddModifier(Modifier) end


---@class UMovieGraphRenderLayerNode : UMovieGraphSettingNode
---@field bOverride_LayerName boolean
---@field LayerName FString
local UMovieGraphRenderLayerNode = {}



---@class UMovieGraphRenderLayerSubsystem : UWorldSubsystem
---@field RenderLayers TArray<UMovieGraphRenderLayer>
---@field ActiveRenderLayer UMovieGraphRenderLayer
local UMovieGraphRenderLayerSubsystem = {}

---@param RenderLayer UMovieGraphRenderLayer
function UMovieGraphRenderLayerSubsystem:SetActiveRenderLayerByObj(RenderLayer) end
---@param RenderLayerName FName
function UMovieGraphRenderLayerSubsystem:SetActiveRenderLayerByName(RenderLayerName) end
function UMovieGraphRenderLayerSubsystem:Reset() end
---@param RenderLayerName FString
function UMovieGraphRenderLayerSubsystem:RemoveRenderLayer(RenderLayerName) end
---@return TArray<UMovieGraphRenderLayer>
function UMovieGraphRenderLayerSubsystem:GetRenderLayers() end
---@param World UWorld
---@return UMovieGraphRenderLayerSubsystem
function UMovieGraphRenderLayerSubsystem:GetFromWorld(World) end
---@return UMovieGraphRenderLayer
function UMovieGraphRenderLayerSubsystem:GetActiveRenderLayer() end
function UMovieGraphRenderLayerSubsystem:ClearActiveRenderLayer() end
---@param RenderLayer UMovieGraphRenderLayer
---@return boolean
function UMovieGraphRenderLayerSubsystem:AddRenderLayer(RenderLayer) end


---@class UMovieGraphRenderPassNode : UMovieGraphSettingNode
local UMovieGraphRenderPassNode = {}


---@class UMovieGraphRenderPreviewWidget : UUserWidget
local UMovieGraphRenderPreviewWidget = {}

---@param InPipeline UMovieGraphPipeline
function UMovieGraphRenderPreviewWidget:OnInitializedForPipeline(InPipeline) end


---@class UMovieGraphRenderPropertyModifier : UMovieGraphCollectionModifier
---@field bOverride_bIsHidden boolean
---@field bOverride_bCastsShadows boolean
---@field bOverride_bCastShadowWhileHidden boolean
---@field bOverride_bAffectIndirectLightingWhileHidden boolean
---@field bOverride_bHoldout boolean
---@field bIsHidden boolean
---@field bCastsShadows boolean
---@field bCastShadowWhileHidden boolean
---@field bAffectIndirectLightingWhileHidden boolean
---@field bHoldout boolean
local UMovieGraphRenderPropertyModifier = {}

function UMovieGraphRenderPropertyModifier:UndoModifier() end
---@param bInIsHidden boolean
function UMovieGraphRenderPropertyModifier:SetHidden(bInIsHidden) end
---@return boolean
function UMovieGraphRenderPropertyModifier:IsHidden() end
---@param World UWorld
function UMovieGraphRenderPropertyModifier:ApplyModifier(World) end


---@class UMovieGraphRendererBase : UObject
local UMovieGraphRendererBase = {}

---@return TArray<FMovieGraphImagePreviewData>
function UMovieGraphRendererBase:GetPreviewData() end


---@class UMovieGraphSamplingMethodNode : UMovieGraphSettingNode
---@field bOverride_SamplingMethodClass boolean
---@field bOverride_TemporalSampleCount boolean
---@field SamplingMethodClass FSoftClassPath
---@field TemporalSampleCount int32
local UMovieGraphSamplingMethodNode = {}



---@class UMovieGraphScriptBase : UObject
local UMovieGraphScriptBase = {}

---@param InJobCopy UMoviePipelineExecutorJob
---@param InShotCopy UMoviePipelineExecutorShot
function UMovieGraphScriptBase:OnShotStart(InJobCopy, InShotCopy) end
---@param InJobCopy UMoviePipelineExecutorJob
---@param InShotCopy UMoviePipelineExecutorShot
---@param OutputData FMoviePipelineOutputData
function UMovieGraphScriptBase:OnShotFinished(InJobCopy, InShotCopy, OutputData) end
---@param InJobCopy UMoviePipelineExecutorJob
function UMovieGraphScriptBase:OnJobStart(InJobCopy) end
---@param InJobCopy UMoviePipelineExecutorJob
---@param InOutputData FMoviePipelineOutputData
function UMovieGraphScriptBase:OnJobFinished(InJobCopy, InOutputData) end
---@return boolean
function UMovieGraphScriptBase:IsPerShotCallbackNeeded() end


---@class UMovieGraphSelectNode : UMovieGraphNode
---@field SelectOptions UMovieGraphValueContainer
---@field SelectedOption UMovieGraphValueContainer
local UMovieGraphSelectNode = {}



---@class UMovieGraphSequenceDataSource : UMovieGraphDataSourceBase
---@field LevelSequenceActor ALevelSequenceActor
local UMovieGraphSequenceDataSource = {}



---@class UMovieGraphSetCVarValueNode : UMovieGraphSettingNode
---@field bOverride_Name boolean
---@field bOverride_Value boolean
---@field Name FString
---@field Value float
local UMovieGraphSetCVarValueNode = {}



---@class UMovieGraphSettingNode : UMovieGraphNode
local UMovieGraphSettingNode = {}


---@class UMovieGraphShowFlags : UObject
---@field OverriddenShowFlags TSet<uint32>
---@field ShowFlagEnableState TMap<uint32, boolean>
local UMovieGraphShowFlags = {}



---@class UMovieGraphSubgraphNode : UMovieGraphNode
---@field SubgraphAsset TSoftObjectPtr<UMovieGraphConfig>
local UMovieGraphSubgraphNode = {}

---@param InSubgraphAsset TSoftObjectPtr<UMovieGraphConfig>
function UMovieGraphSubgraphNode:SetSubGraphAsset(InSubgraphAsset) end
---@return UMovieGraphConfig
function UMovieGraphSubgraphNode:GetSubgraphAsset() end


---@class UMovieGraphTimeStepBase : UObject
local UMovieGraphTimeStepBase = {}

---@return FMovieGraphTimeStepData
function UMovieGraphTimeStepBase:GetCalculatedTimeData() end


---@class UMovieGraphUIRendererNode : UMovieGraphWidgetRendererBaseNode
local UMovieGraphUIRendererNode = {}


---@class UMovieGraphValueContainer : UObject
---@field PropertyName FName
---@field Value FInstancedPropertyBag
local UMovieGraphValueContainer = {}

---@param ValueTypeObject UObject
function UMovieGraphValueContainer:SetValueTypeObject(ValueTypeObject) end
---@param ValueType EMovieGraphValueType
---@param InValueTypeObject UObject
function UMovieGraphValueContainer:SetValueType(ValueType, InValueTypeObject) end
---@param InValue FText
---@return boolean
function UMovieGraphValueContainer:SetValueText(InValue) end
---@param InValue FString
---@return boolean
function UMovieGraphValueContainer:SetValueString(InValue) end
---@param NewValue FString
---@return boolean
function UMovieGraphValueContainer:SetValueSerializedString(NewValue) end
---@param InValue UObject
---@return boolean
function UMovieGraphValueContainer:SetValueObject(InValue) end
---@param InValue FName
---@return boolean
function UMovieGraphValueContainer:SetValueName(InValue) end
---@param InValue int64
---@return boolean
function UMovieGraphValueContainer:SetValueInt64(InValue) end
---@param InValue int32
---@return boolean
function UMovieGraphValueContainer:SetValueInt32(InValue) end
---@param InValue float
---@return boolean
function UMovieGraphValueContainer:SetValueFloat(InValue) end
---@param InValue uint8
---@param Enum UEnum
---@return boolean
function UMovieGraphValueContainer:SetValueEnum(InValue, Enum) end
---@param InValue double
---@return boolean
function UMovieGraphValueContainer:SetValueDouble(InValue) end
---@param ContainerType EMovieGraphContainerType
function UMovieGraphValueContainer:SetValueContainerType(ContainerType) end
---@param InValue UClass
---@return boolean
function UMovieGraphValueContainer:SetValueClass(InValue) end
---@param InValue uint8
---@return boolean
function UMovieGraphValueContainer:SetValueByte(InValue) end
---@param bInValue boolean
---@return boolean
function UMovieGraphValueContainer:SetValueBool(bInValue) end
---@return UObject
function UMovieGraphValueContainer:GetValueTypeObject() end
---@return EMovieGraphValueType
function UMovieGraphValueContainer:GetValueType() end
---@param OutValue FText
---@return boolean
function UMovieGraphValueContainer:GetValueText(OutValue) end
---@param OutValue FString
---@return boolean
function UMovieGraphValueContainer:GetValueString(OutValue) end
---@return FString
function UMovieGraphValueContainer:GetValueSerializedString() end
---@param OutValue UObject
---@param RequestedClass UClass
---@return boolean
function UMovieGraphValueContainer:GetValueObject(OutValue, RequestedClass) end
---@param OutValue FName
---@return boolean
function UMovieGraphValueContainer:GetValueName(OutValue) end
---@param OutValue int64
---@return boolean
function UMovieGraphValueContainer:GetValueInt64(OutValue) end
---@param OutValue int32
---@return boolean
function UMovieGraphValueContainer:GetValueInt32(OutValue) end
---@param OutValue float
---@return boolean
function UMovieGraphValueContainer:GetValueFloat(OutValue) end
---@param OutValue uint8
---@param RequestedEnum UEnum
---@return boolean
function UMovieGraphValueContainer:GetValueEnum(OutValue, RequestedEnum) end
---@param OutValue double
---@return boolean
function UMovieGraphValueContainer:GetValueDouble(OutValue) end
---@return EMovieGraphContainerType
function UMovieGraphValueContainer:GetValueContainerType() end
---@param OutValue UClass
---@return boolean
function UMovieGraphValueContainer:GetValueClass(OutValue) end
---@param OutValue uint8
---@return boolean
function UMovieGraphValueContainer:GetValueByte(OutValue) end
---@param bOutValue boolean
---@return boolean
function UMovieGraphValueContainer:GetValueBool(bOutValue) end


---@class UMovieGraphVariable : UMovieGraphMember
local UMovieGraphVariable = {}


---@class UMovieGraphVariableNode : UMovieGraphNode
---@field GraphVariable UMovieGraphVariable
---@field OutputPin FMovieGraphPinProperties
local UMovieGraphVariableNode = {}

---@param InVariable UMovieGraphVariable
function UMovieGraphVariableNode:SetVariable(InVariable) end
---@return UMovieGraphVariable
function UMovieGraphVariableNode:GetVariable() end


---@class UMovieGraphWarmUpSettingNode : UMovieGraphSettingNode
---@field bOverride_NumWarmUpFrames boolean
---@field bOverride_bEmulateMotionBlur boolean
---@field NumWarmUpFrames int32
---@field bEmulateMotionBlur boolean
local UMovieGraphWarmUpSettingNode = {}



---@class UMovieGraphWidgetRendererBaseNode : UMovieGraphRenderPassNode
---@field bOverride_bCompositeOntoFinalImage boolean
---@field bCompositeOntoFinalImage boolean
local UMovieGraphWidgetRendererBaseNode = {}



---@class UMovieJobVariableAssignmentContainer : UObject
---@field Value FInstancedPropertyBag
---@field GraphPreset TSoftObjectPtr<UMovieGraphConfig>
local UMovieJobVariableAssignmentContainer = {}

---@param InGraphVariable UMovieGraphVariable
---@param bIsEnabled boolean
---@return boolean
function UMovieJobVariableAssignmentContainer:SetVariableAssignmentEnableState(InGraphVariable, bIsEnabled) end
---@param InGraphVariable UMovieGraphVariable
---@param InValue FText
---@return boolean
function UMovieJobVariableAssignmentContainer:SetValueText(InGraphVariable, InValue) end
---@param InGraphVariable UMovieGraphVariable
---@param InValue FString
---@return boolean
function UMovieJobVariableAssignmentContainer:SetValueString(InGraphVariable, InValue) end
---@param InGraphVariable UMovieGraphVariable
---@param NewValue FString
---@return boolean
function UMovieJobVariableAssignmentContainer:SetValueSerializedString(InGraphVariable, NewValue) end
---@param InGraphVariable UMovieGraphVariable
---@param InValue UObject
---@return boolean
function UMovieJobVariableAssignmentContainer:SetValueObject(InGraphVariable, InValue) end
---@param InGraphVariable UMovieGraphVariable
---@param InValue FName
---@return boolean
function UMovieJobVariableAssignmentContainer:SetValueName(InGraphVariable, InValue) end
---@param InGraphVariable UMovieGraphVariable
---@param InValue int64
---@return boolean
function UMovieJobVariableAssignmentContainer:SetValueInt64(InGraphVariable, InValue) end
---@param InGraphVariable UMovieGraphVariable
---@param InValue int32
---@return boolean
function UMovieJobVariableAssignmentContainer:SetValueInt32(InGraphVariable, InValue) end
---@param InGraphVariable UMovieGraphVariable
---@param InValue float
---@return boolean
function UMovieJobVariableAssignmentContainer:SetValueFloat(InGraphVariable, InValue) end
---@param InGraphVariable UMovieGraphVariable
---@param InValue uint8
---@param Enum UEnum
---@return boolean
function UMovieJobVariableAssignmentContainer:SetValueEnum(InGraphVariable, InValue, Enum) end
---@param InGraphVariable UMovieGraphVariable
---@param InValue double
---@return boolean
function UMovieJobVariableAssignmentContainer:SetValueDouble(InGraphVariable, InValue) end
---@param InGraphVariable UMovieGraphVariable
---@param InValue UClass
---@return boolean
function UMovieJobVariableAssignmentContainer:SetValueClass(InGraphVariable, InValue) end
---@param InGraphVariable UMovieGraphVariable
---@param InValue uint8
---@return boolean
function UMovieJobVariableAssignmentContainer:SetValueByte(InGraphVariable, InValue) end
---@param InGraphVariable UMovieGraphVariable
---@param bInValue boolean
---@return boolean
function UMovieJobVariableAssignmentContainer:SetValueBool(InGraphVariable, bInValue) end
---@param InGraphConfig TSoftObjectPtr<UMovieGraphConfig>
function UMovieJobVariableAssignmentContainer:SetGraphConfig(InGraphConfig) end
---@param InGraphVariable UMovieGraphVariable
---@param bOutIsEnabled boolean
---@return boolean
function UMovieJobVariableAssignmentContainer:GetVariableAssignmentEnableState(InGraphVariable, bOutIsEnabled) end
---@param InGraphVariable UMovieGraphVariable
---@return UObject
function UMovieJobVariableAssignmentContainer:GetValueTypeObject(InGraphVariable) end
---@param InGraphVariable UMovieGraphVariable
---@return EMovieGraphValueType
function UMovieJobVariableAssignmentContainer:GetValueType(InGraphVariable) end
---@param InGraphVariable UMovieGraphVariable
---@param OutValue FText
---@return boolean
function UMovieJobVariableAssignmentContainer:GetValueText(InGraphVariable, OutValue) end
---@param InGraphVariable UMovieGraphVariable
---@param OutValue FString
---@return boolean
function UMovieJobVariableAssignmentContainer:GetValueString(InGraphVariable, OutValue) end
---@param InGraphVariable UMovieGraphVariable
---@return FString
function UMovieJobVariableAssignmentContainer:GetValueSerializedString(InGraphVariable) end
---@param InGraphVariable UMovieGraphVariable
---@param OutValue UObject
---@param RequestedClass UClass
---@return boolean
function UMovieJobVariableAssignmentContainer:GetValueObject(InGraphVariable, OutValue, RequestedClass) end
---@param InGraphVariable UMovieGraphVariable
---@param OutValue FName
---@return boolean
function UMovieJobVariableAssignmentContainer:GetValueName(InGraphVariable, OutValue) end
---@param InGraphVariable UMovieGraphVariable
---@param OutValue int64
---@return boolean
function UMovieJobVariableAssignmentContainer:GetValueInt64(InGraphVariable, OutValue) end
---@param InGraphVariable UMovieGraphVariable
---@param OutValue int32
---@return boolean
function UMovieJobVariableAssignmentContainer:GetValueInt32(InGraphVariable, OutValue) end
---@param InGraphVariable UMovieGraphVariable
---@param OutValue float
---@return boolean
function UMovieJobVariableAssignmentContainer:GetValueFloat(InGraphVariable, OutValue) end
---@param InGraphVariable UMovieGraphVariable
---@param OutValue uint8
---@param RequestedEnum UEnum
---@return boolean
function UMovieJobVariableAssignmentContainer:GetValueEnum(InGraphVariable, OutValue, RequestedEnum) end
---@param InGraphVariable UMovieGraphVariable
---@param OutValue double
---@return boolean
function UMovieJobVariableAssignmentContainer:GetValueDouble(InGraphVariable, OutValue) end
---@param InGraphVariable UMovieGraphVariable
---@return EMovieGraphContainerType
function UMovieJobVariableAssignmentContainer:GetValueContainerType(InGraphVariable) end
---@param InGraphVariable UMovieGraphVariable
---@param OutValue UClass
---@return boolean
function UMovieJobVariableAssignmentContainer:GetValueClass(InGraphVariable, OutValue) end
---@param InGraphVariable UMovieGraphVariable
---@param OutValue uint8
---@return boolean
function UMovieJobVariableAssignmentContainer:GetValueByte(InGraphVariable, OutValue) end
---@param InGraphVariable UMovieGraphVariable
---@param bOutValue boolean
---@return boolean
function UMovieJobVariableAssignmentContainer:GetValueBool(InGraphVariable, bOutValue) end


---@class UMoviePipeline : UMoviePipelineBase
---@field OnMoviePipelineFinishedDelegate FMoviePipelineOnMoviePipelineFinishedDelegate
---@field CustomTimeStep UMoviePipelineCustomTimeStep
---@field CachedPrevCustomTimeStep UEngineCustomTimeStep
---@field TargetSequence ULevelSequence
---@field LevelSequenceActor ALevelSequenceActor
---@field DebugWidget UMovieRenderDebugWidget
---@field PreviewTexture UTexture
---@field DebugWidgetClass TSubclassOf<UMovieRenderDebugWidget>
---@field CurrentJob UMoviePipelineExecutorJob
local UMoviePipeline = {}

---@param InDateTime FDateTime
function UMoviePipeline:SetInitializationTime(InDateTime) end
function UMoviePipeline:OnMoviePipelineFinishedImpl() end
---@param InJob UMoviePipelineExecutorJob
function UMoviePipeline:Initialize(InJob) end
---@return UTexture
function UMoviePipeline:GetPreviewTexture() end
---@return UMoviePipelinePrimaryConfig
function UMoviePipeline:GetPipelinePrimaryConfig() end
---@return UMoviePipelinePrimaryConfig
function UMoviePipeline:GetPipelineMasterConfig() end
---@return FTimespan
function UMoviePipeline:GetInitializationTimeOffset() end
---@return FDateTime
function UMoviePipeline:GetInitializationTime() end
---@return UMoviePipelineExecutorJob
function UMoviePipeline:GetCurrentJob() end


---@class UMoviePipelineAntiAliasingSetting : UMoviePipelineSetting
---@field SpatialSampleCount int32
---@field TemporalSampleCount int32
---@field bOverrideAntiAliasing boolean
---@field AntiAliasingMethod EAntiAliasingMethod
---@field RenderWarmUpCount int32
---@field bUseCameraCutForWarmUp boolean
---@field EngineWarmUpCount int32
---@field bRenderWarmUpFrames boolean
local UMoviePipelineAntiAliasingSetting = {}



---@class UMoviePipelineBase : UObject
---@field OnMoviePipelineWorkFinishedDelegate FMoviePipelineBaseOnMoviePipelineWorkFinishedDelegate
---@field OnMoviePipelineShotWorkFinishedDelegate FMoviePipelineBaseOnMoviePipelineShotWorkFinishedDelegate
local UMoviePipelineBase = {}

---@param bIsError boolean
function UMoviePipelineBase:Shutdown(bIsError) end
---@param bIsError boolean
function UMoviePipelineBase:RequestShutdown(bIsError) end
---@return boolean
function UMoviePipelineBase:IsShutdownRequested() end
---@return EMovieRenderPipelineState
function UMoviePipelineBase:GetPipelineState() end


---@class UMoviePipelineBlueprintLibrary : UBlueprintFunctionLibrary
local UMoviePipelineBlueprintLibrary = {}

---@param InSequence ULevelSequence
---@param InJob UMoviePipelineExecutorJob
---@param bShotsChanged boolean
function UMoviePipelineBlueprintLibrary:UpdateJobShotListFromSequence(InSequence, InJob, bShotsChanged) end
---@param InParams FMoviePipelineFilenameResolveParams
---@param bGetNextVersion boolean
---@return int32
function UMoviePipelineBlueprintLibrary:ResolveVersionNumber(InParams, bGetNextVersion) end
---@param InFormatString FString
---@param InParams FMoviePipelineFilenameResolveParams
---@param OutFinalPath FString
---@param OutMergedFormatArgs FMoviePipelineFormatArgs
function UMoviePipelineBlueprintLibrary:ResolveFilenameFormatArguments(InFormatString, InParams, OutFinalPath, OutMergedFormatArgs) end
---@param InManifestFilePath FString
---@return UMoviePipelineQueue
function UMoviePipelineBlueprintLibrary:LoadManifestFileFromString(InManifestFilePath) end
---@param InMoviePipeline UMoviePipeline
---@return FTimecode
function UMoviePipelineBlueprintLibrary:GetRootTimecode(InMoviePipeline) end
---@param InMoviePipeline UMoviePipeline
---@return FFrameNumber
function UMoviePipelineBlueprintLibrary:GetRootFrameNumber(InMoviePipeline) end
---@param InPipeline UMoviePipeline
---@return EMovieRenderPipelineState
function UMoviePipelineBlueprintLibrary:GetPipelineState(InPipeline) end
---@param InMoviePipeline UMoviePipeline
---@param OutCurrentIndex int32
---@param OutTotalCount int32
function UMoviePipelineBlueprintLibrary:GetOverallSegmentCounts(InMoviePipeline, OutCurrentIndex, OutTotalCount) end
---@param InMoviePipeline UMoviePipeline
---@param OutCurrentIndex int32
---@param OutTotalCount int32
function UMoviePipelineBlueprintLibrary:GetOverallOutputFrames(InMoviePipeline, OutCurrentIndex, OutTotalCount) end
---@param InMoviePipeline UMoviePipeline
---@return FText
function UMoviePipelineBlueprintLibrary:GetMoviePipelineEngineChangelistLabel(InMoviePipeline) end
---@param InMoviePipeline UMoviePipeline
---@return FTimecode
function UMoviePipelineBlueprintLibrary:GetMasterTimecode(InMoviePipeline) end
---@param InMoviePipeline UMoviePipeline
---@return FFrameNumber
function UMoviePipelineBlueprintLibrary:GetMasterFrameNumber(InMoviePipeline) end
---@param InJob UMoviePipelineExecutorJob
---@return FString
function UMoviePipelineBlueprintLibrary:GetMapPackageName(InJob) end
---@param InMoviePipeline UMoviePipeline
---@return FText
function UMoviePipelineBlueprintLibrary:GetJobName(InMoviePipeline) end
---@param InMoviePipeline UMoviePipeline
---@return FDateTime
function UMoviePipelineBlueprintLibrary:GetJobInitializationTime(InMoviePipeline) end
---@param InMoviePipeline UMoviePipeline
---@return FText
function UMoviePipelineBlueprintLibrary:GetJobAuthor(InMoviePipeline) end
---@param InPipeline UMoviePipeline
---@param OutEstimate FTimespan
---@return boolean
function UMoviePipelineBlueprintLibrary:GetEstimatedTimeRemaining(InPipeline, OutEstimate) end
---@param InPrimaryConfig UMoviePipelinePrimaryConfig
---@param InPipelineExecutorShot UMoviePipelineExecutorShot
---@return FIntPoint
function UMoviePipelineBlueprintLibrary:GetEffectiveOutputResolution(InPrimaryConfig, InPipelineExecutorShot) end
---@param InMoviePipeline UMoviePipeline
---@return FTimecode
function UMoviePipelineBlueprintLibrary:GetCurrentShotTimecode(InMoviePipeline) end
---@param InMoviePipeline UMoviePipeline
---@return FFrameNumber
function UMoviePipelineBlueprintLibrary:GetCurrentShotFrameNumber(InMoviePipeline) end
---@param InMoviePipeline UMoviePipeline
---@return ULevelSequence
function UMoviePipelineBlueprintLibrary:GetCurrentSequence(InMoviePipeline) end
---@param InMoviePipeline UMoviePipeline
---@return FMoviePipelineSegmentWorkMetrics
function UMoviePipelineBlueprintLibrary:GetCurrentSegmentWorkMetrics(InMoviePipeline) end
---@param InMoviePipeline UMoviePipeline
---@return EMovieRenderShotState
function UMoviePipelineBlueprintLibrary:GetCurrentSegmentState(InMoviePipeline) end
---@param InMoviePipeline UMoviePipeline
---@param OutOuterName FText
---@param OutInnerName FText
function UMoviePipelineBlueprintLibrary:GetCurrentSegmentName(InMoviePipeline, OutOuterName, OutInnerName) end
---@param InMoviePipeline UMoviePipeline
---@return float
function UMoviePipelineBlueprintLibrary:GetCurrentFocusDistance(InMoviePipeline) end
---@param InMoviePipeline UMoviePipeline
---@return float
function UMoviePipelineBlueprintLibrary:GetCurrentFocalLength(InMoviePipeline) end
---@param InMoviePipeline UMoviePipeline
---@return UMoviePipelineExecutorShot
function UMoviePipelineBlueprintLibrary:GetCurrentExecutorShot(InMoviePipeline) end
---@param InMoviePipeline UMoviePipeline
---@return float
function UMoviePipelineBlueprintLibrary:GetCurrentAperture(InMoviePipeline) end
---@param InPipeline UMoviePipeline
---@return float
function UMoviePipelineBlueprintLibrary:GetCompletionPercentage(InPipeline) end
---@param InSettingType TSubclassOf<UMoviePipelineSetting>
---@param InPrimaryConfig UMoviePipelinePrimaryConfig
---@param InShot UMoviePipelineExecutorShot
---@return UMoviePipelineSetting
function UMoviePipelineBlueprintLibrary:FindOrGetDefaultSettingForShot(InSettingType, InPrimaryConfig, InShot) end
---@param Outer UObject
---@param InSequence UMovieSceneSequence
---@return UMovieSceneSequence
function UMoviePipelineBlueprintLibrary:DuplicateSequence(Outer, InSequence) end


---@class UMoviePipelineCameraSetting : UMoviePipelineSetting
---@field ShutterTiming EMoviePipelineShutterTiming
---@field OverscanPercentage float
---@field bRenderAllCameras boolean
local UMoviePipelineCameraSetting = {}



---@class UMoviePipelineColorSetting : UMoviePipelineSetting
---@field OCIOConfiguration FOpenColorIODisplayConfiguration
---@field bDisableToneCurve boolean
local UMoviePipelineColorSetting = {}



---@class UMoviePipelineCommandLineEncoder : UMoviePipelineSetting
---@field FileNameFormatOverride FString
---@field Quality EMoviePipelineEncodeQuality
---@field AdditionalCommandLineArgs FString
---@field bDeleteSourceFiles boolean
---@field bSkipEncodeOnRenderCanceled boolean
---@field bWriteEachFrameDuration boolean
local UMoviePipelineCommandLineEncoder = {}



---@class UMoviePipelineCommandLineEncoderSettings : UDeveloperSettings
---@field ExecutablePath FString
---@field CodecHelpText FText
---@field VideoCodec FString
---@field AudioCodec FString
---@field OutputFileExtension FString
---@field CommandLineFormat FString
---@field VideoInputStringFormat FString
---@field AudioInputStringFormat FString
---@field EncodeSettings_Low FString
---@field EncodeSettings_Med FString
---@field EncodeSettings_High FString
---@field EncodeSettings_Epic FString
local UMoviePipelineCommandLineEncoderSettings = {}



---@class UMoviePipelineConfigBase : UObject
---@field DisplayName FString
---@field Settings TArray<UMoviePipelineSetting>
---@field ConfigOrigin TSoftObjectPtr<UMoviePipelineConfigBase>
local UMoviePipelineConfigBase = {}

---@param InConfig UMoviePipelineConfigBase
function UMoviePipelineConfigBase:SetConfigOrigin(InConfig) end
---@param InSetting UMoviePipelineSetting
function UMoviePipelineConfigBase:RemoveSetting(InSetting) end
---@return TArray<UMoviePipelineSetting>
function UMoviePipelineConfigBase:GetUserSettings() end
---@return UMoviePipelineConfigBase
function UMoviePipelineConfigBase:GetConfigOrigin() end
---@param InClass TSubclassOf<UMoviePipelineSetting>
---@param bIncludeDisabledSettings boolean
---@param bExactMatch boolean
---@return TArray<UMoviePipelineSetting>
function UMoviePipelineConfigBase:FindSettingsByClass(InClass, bIncludeDisabledSettings, bExactMatch) end
---@param InClass TSubclassOf<UMoviePipelineSetting>
---@param bIncludeDisabledSettings boolean
---@param bExactMatch boolean
---@return UMoviePipelineSetting
function UMoviePipelineConfigBase:FindSettingByClass(InClass, bIncludeDisabledSettings, bExactMatch) end
---@param InClass TSubclassOf<UMoviePipelineSetting>
---@param bIncludeDisabledSettings boolean
---@param bExactMatch boolean
---@return UMoviePipelineSetting
function UMoviePipelineConfigBase:FindOrAddSettingByClass(InClass, bIncludeDisabledSettings, bExactMatch) end
---@param InConfig UMoviePipelineConfigBase
function UMoviePipelineConfigBase:CopyFrom(InConfig) end


---@class UMoviePipelineCustomTimeStep : UEngineCustomTimeStep
local UMoviePipelineCustomTimeStep = {}


---@class UMoviePipelineDebugSettings : UMoviePipelineSetting
---@field bWriteAllSamples boolean
---@field bCaptureFramesWithRenderDoc boolean
---@field CaptureFrame int32
---@field bCaptureUnrealInsightsTrace boolean
local UMoviePipelineDebugSettings = {}



---@class UMoviePipelineExecutorBase : UObject
---@field OnExecutorFinishedDelegate FMoviePipelineExecutorBaseOnExecutorFinishedDelegate
---@field OnExecutorErroredDelegate FMoviePipelineExecutorBaseOnExecutorErroredDelegate
---@field SocketMessageRecievedDelegate FMoviePipelineExecutorBaseSocketMessageRecievedDelegate
---@field HTTPResponseRecievedDelegate FMoviePipelineExecutorBaseHTTPResponseRecievedDelegate
---@field DebugWidgetClass TSubclassOf<UMovieRenderDebugWidget>
---@field UserData FString
---@field TargetPipelineClass TSubclassOf<UMoviePipeline>
local UMoviePipelineExecutorBase = {}

---@param InProgress float
function UMoviePipelineExecutorBase:SetStatusProgress(InProgress) end
---@param InStatus FString
function UMoviePipelineExecutorBase:SetStatusMessage(InStatus) end
---@param InPipelineClass UClass
function UMoviePipelineExecutorBase:SetMoviePipelineClass(InPipelineClass) end
---@param InMessage FString
---@return boolean
function UMoviePipelineExecutorBase:SendSocketMessage(InMessage) end
---@param InURL FString
---@param InVerb FString
---@param InMessage FString
---@param InHeaders TMap<FString, FString>
---@return int32
function UMoviePipelineExecutorBase:SendHTTPRequest(InURL, InVerb, InMessage, InHeaders) end
function UMoviePipelineExecutorBase:OnExecutorFinishedImpl() end
---@param ErroredPipeline UMoviePipeline
---@param bFatal boolean
---@param ErrorReason FText
function UMoviePipelineExecutorBase:OnExecutorErroredImpl(ErroredPipeline, bFatal, ErrorReason) end
function UMoviePipelineExecutorBase:OnBeginFrame() end
---@return boolean
function UMoviePipelineExecutorBase:IsSocketConnected() end
---@return boolean
function UMoviePipelineExecutorBase:IsRendering() end
---@return float
function UMoviePipelineExecutorBase:GetStatusProgress() end
---@return FString
function UMoviePipelineExecutorBase:GetStatusMessage() end
---@param InPipelineQueue UMoviePipelineQueue
function UMoviePipelineExecutorBase:Execute(InPipelineQueue) end
function UMoviePipelineExecutorBase:DisconnectSocket() end
---@param InHostName FString
---@param InPort int32
---@return boolean
function UMoviePipelineExecutorBase:ConnectSocket(InHostName, InPort) end
function UMoviePipelineExecutorBase:CancelCurrentJob() end
function UMoviePipelineExecutorBase:CancelAllJobs() end


---@class UMoviePipelineExecutorJob : UObject
---@field JobName FString
---@field Sequence FSoftObjectPath
---@field Map FSoftObjectPath
---@field Author FString
---@field Comment FString
---@field ShotInfo TArray<UMoviePipelineExecutorShot>
---@field UserData FString
---@field StatusMessage FString
---@field StatusProgress float
---@field bIsConsumed boolean
---@field Configuration UMoviePipelinePrimaryConfig
---@field PresetOrigin TSoftObjectPtr<UMoviePipelinePrimaryConfig>
---@field bEnabled boolean
---@field GraphPreset TSoftObjectPtr<UMovieGraphConfig>
---@field GraphVariableAssignments TArray<UMovieJobVariableAssignmentContainer>
local UMoviePipelineExecutorJob = {}

---@param InProgress float
function UMoviePipelineExecutorJob:SetStatusProgress(InProgress) end
---@param InStatus FString
function UMoviePipelineExecutorJob:SetStatusMessage(InStatus) end
---@param InSequence FSoftObjectPath
function UMoviePipelineExecutorJob:SetSequence(InSequence) end
---@param InPreset UMoviePipelinePrimaryConfig
function UMoviePipelineExecutorJob:SetPresetOrigin(InPreset) end
---@param bInEnabled boolean
function UMoviePipelineExecutorJob:SetIsEnabled(bInEnabled) end
---@param InGraphPreset UMovieGraphConfig
---@param bUpdateVariableAssignments boolean
function UMoviePipelineExecutorJob:SetGraphPreset(InGraphPreset, bUpdateVariableAssignments) end
---@param bInConsumed boolean
function UMoviePipelineExecutorJob:SetConsumed(bInConsumed) end
---@param InPreset UMoviePipelinePrimaryConfig
function UMoviePipelineExecutorJob:SetConfiguration(InPreset) end
function UMoviePipelineExecutorJob:OnDuplicated() end
---@return boolean
function UMoviePipelineExecutorJob:IsUsingGraphConfiguration() end
---@return boolean
function UMoviePipelineExecutorJob:IsEnabled() end
---@return boolean
function UMoviePipelineExecutorJob:IsConsumed() end
---@return float
function UMoviePipelineExecutorJob:GetStatusProgress() end
---@return FString
function UMoviePipelineExecutorJob:GetStatusMessage() end
---@return UMoviePipelinePrimaryConfig
function UMoviePipelineExecutorJob:GetPresetOrigin() end
---@param InGraph UMovieGraphConfig
---@return UMovieJobVariableAssignmentContainer
function UMoviePipelineExecutorJob:GetOrCreateJobVariableAssignmentsForGraph(InGraph) end
---@return UMovieGraphConfig
function UMoviePipelineExecutorJob:GetGraphPreset() end
---@return UMoviePipelinePrimaryConfig
function UMoviePipelineExecutorJob:GetConfiguration() end


---@class UMoviePipelineExecutorShot : UObject
---@field bEnabled boolean
---@field OuterName FString
---@field InnerName FString
---@field SidecarCameras TArray<FMoviePipelineSidecarCamera>
---@field progress float
---@field StatusMessage FString
---@field ShotOverrideConfig UMoviePipelineShotConfig
---@field ShotOverridePresetOrigin TSoftObjectPtr<UMoviePipelineShotConfig>
---@field GraphPreset TSoftObjectPtr<UMovieGraphConfig>
---@field GraphVariableAssignments TArray<UMovieJobVariableAssignmentContainer>
---@field PrimaryGraphVariableAssignments TArray<UMovieJobVariableAssignmentContainer>
local UMoviePipelineExecutorShot = {}

---@return boolean
function UMoviePipelineExecutorShot:ShouldRender() end
---@param InProgress float
function UMoviePipelineExecutorShot:SetStatusProgress(InProgress) end
---@param InStatus FString
function UMoviePipelineExecutorShot:SetStatusMessage(InStatus) end
---@param InPreset UMoviePipelineShotConfig
function UMoviePipelineExecutorShot:SetShotOverridePresetOrigin(InPreset) end
---@param InPreset UMoviePipelineShotConfig
function UMoviePipelineExecutorShot:SetShotOverrideConfiguration(InPreset) end
---@param InGraphPreset UMovieGraphConfig
---@param bUpdateVariableAssignments boolean
function UMoviePipelineExecutorShot:SetGraphPreset(InGraphPreset, bUpdateVariableAssignments) end
---@return boolean
function UMoviePipelineExecutorShot:IsUsingGraphConfiguration() end
---@return float
function UMoviePipelineExecutorShot:GetStatusProgress() end
---@return FString
function UMoviePipelineExecutorShot:GetStatusMessage() end
---@return UMoviePipelineShotConfig
function UMoviePipelineExecutorShot:GetShotOverridePresetOrigin() end
---@return UMoviePipelineShotConfig
function UMoviePipelineExecutorShot:GetShotOverrideConfiguration() end
---@param InGraph UMovieGraphConfig
---@param bIsForPrimaryOverrides boolean
---@return UMovieJobVariableAssignmentContainer
function UMoviePipelineExecutorShot:GetOrCreateJobVariableAssignmentsForGraph(InGraph, bIsForPrimaryOverrides) end
---@return UMovieGraphConfig
function UMoviePipelineExecutorShot:GetGraphPreset() end
---@param InCameraIndex int32
---@return FString
function UMoviePipelineExecutorShot:GetCameraName(InCameraIndex) end
---@param InConfigType TSubclassOf<UMoviePipelineShotConfig>
---@return UMoviePipelineShotConfig
function UMoviePipelineExecutorShot:AllocateNewShotOverrideConfig(InConfigType) end


---@class UMoviePipelineFCPXMLExporter : UMoviePipelineOutputBase
---@field FileNameFormatOverride FString
---@field DataSource FCPXMLExportDataSource
local UMoviePipelineFCPXMLExporter = {}



---@class UMoviePipelineGameOverrideSetting : UMoviePipelineSetting
---@field GameModeOverride TSubclassOf<AGameModeBase>
---@field bCinematicQualitySettings boolean
---@field TextureStreaming EMoviePipelineTextureStreamingMethod
---@field bUseLODZero boolean
---@field bDisableHLODs boolean
---@field bUseHighQualityShadows boolean
---@field ShadowDistanceScale int32
---@field ShadowRadiusThreshold float
---@field bOverrideViewDistanceScale boolean
---@field ViewDistanceScale int32
---@field bFlushGrassStreaming boolean
---@field bFlushStreamingManagers boolean
---@field bOverrideVirtualTextureFeedbackFactor boolean
---@field VirtualTextureFeedbackFactor int32
local UMoviePipelineGameOverrideSetting = {}



---@class UMoviePipelineHighResSetting : UMoviePipelineSetting
---@field TileCount int32
---@field TextureSharpnessBias float
---@field OverlapRatio float
---@field bOverrideSubSurfaceScattering boolean
---@field BurleySampleCount int32
---@field bAllocateHistoryPerTile boolean
local UMoviePipelineHighResSetting = {}



---@class UMoviePipelineInProcessExecutor : UMoviePipelineLinearExecutorBase
---@field bUseCurrentLevel boolean
local UMoviePipelineInProcessExecutor = {}



---@class UMoviePipelineInProcessExecutorSettings : UDeveloperSettings
---@field bCloseEditor boolean
---@field AdditionalCommandLineArguments FString
---@field InheritedCommandLineArguments FString
---@field InitialDelayFrameCount int32
local UMoviePipelineInProcessExecutorSettings = {}



---@class UMoviePipelineLinearExecutorBase : UMoviePipelineExecutorBase
---@field Queue UMoviePipelineQueue
---@field ActiveMoviePipeline UMoviePipelineBase
local UMoviePipelineLinearExecutorBase = {}



---@class UMoviePipelineOutputBase : UMoviePipelineSetting
local UMoviePipelineOutputBase = {}


---@class UMoviePipelineOutputSetting : UMoviePipelineSetting
---@field OutputDirectory FDirectoryPath
---@field FileNameFormat FString
---@field OutputResolution FIntPoint
---@field bUseCustomFrameRate boolean
---@field OutputFrameRate FFrameRate
---@field bOverrideExistingOutput boolean
---@field HandleFrameCount int32
---@field OutputFrameStep int32
---@field bUseCustomPlaybackRange boolean
---@field CustomStartFrame int32
---@field CustomEndFrame int32
---@field VersionNumber int32
---@field bAutoVersion boolean
---@field ZeroPadFrameNumbers int32
---@field FrameNumberOffset int32
---@field bFlushDiskWritesPerShot boolean
local UMoviePipelineOutputSetting = {}



---@class UMoviePipelinePrimaryConfig : UMoviePipelineConfigBase
---@field PerShotConfigMapping TMap<FString, UMoviePipelineShotConfig>
---@field OutputSetting UMoviePipelineOutputSetting
---@field TransientSettings TArray<UMoviePipelineSetting>
local UMoviePipelinePrimaryConfig = {}

function UMoviePipelinePrimaryConfig:InitializeTransientSettings() end
---@return TArray<UMoviePipelineSetting>
function UMoviePipelinePrimaryConfig:GetTransientSettings() end
---@param InSequence ULevelSequence
---@return FFrameRate
function UMoviePipelinePrimaryConfig:GetEffectiveFrameRate(InSequence) end
---@param bIncludeDisabledSettings boolean
---@param bIncludeTransientSettings boolean
---@return TArray<UMoviePipelineSetting>
function UMoviePipelinePrimaryConfig:GetAllSettings(bIncludeDisabledSettings, bIncludeTransientSettings) end


---@class UMoviePipelinePythonHostExecutor : UMoviePipelineExecutorBase
---@field ExecutorClass TSubclassOf<UMoviePipelinePythonHostExecutor>
---@field PipelineQueue UMoviePipelineQueue
---@field LastLoadedWorld UWorld
local UMoviePipelinePythonHostExecutor = {}

---@param InWorld UWorld
function UMoviePipelinePythonHostExecutor:OnMapLoad(InWorld) end
---@return UWorld
function UMoviePipelinePythonHostExecutor:GetLastLoadedWorld() end
---@param InPipelineQueue UMoviePipelineQueue
function UMoviePipelinePythonHostExecutor:ExecuteDelayed(InPipelineQueue) end


---@class UMoviePipelineQueue : UObject
---@field Jobs TArray<UMoviePipelineExecutorJob>
---@field QueueOrigin TSoftObjectPtr<UMoviePipelineQueue>
local UMoviePipelineQueue = {}

---@param InConfig UMoviePipelineQueue
function UMoviePipelineQueue:SetQueueOrigin(InConfig) end
---@param InJob UMoviePipelineExecutorJob
---@param Index int32
function UMoviePipelineQueue:SetJobIndex(InJob, Index) end
---@return UMoviePipelineQueue
function UMoviePipelineQueue:GetQueueOrigin() end
---@return TArray<UMoviePipelineExecutorJob>
function UMoviePipelineQueue:GetJobs() end
---@param InJob UMoviePipelineExecutorJob
---@return UMoviePipelineExecutorJob
function UMoviePipelineQueue:DuplicateJob(InJob) end
---@param InJob UMoviePipelineExecutorJob
function UMoviePipelineQueue:DeleteJob(InJob) end
function UMoviePipelineQueue:DeleteAllJobs() end
---@param InQueue UMoviePipelineQueue
function UMoviePipelineQueue:CopyFrom(InQueue) end
---@param InJobType TSubclassOf<UMoviePipelineExecutorJob>
---@return UMoviePipelineExecutorJob
function UMoviePipelineQueue:AllocateNewJob(InJobType) end


---@class UMoviePipelineQueueEngineSubsystem : UEngineSubsystem
---@field OnRenderFinished FMoviePipelineQueueEngineSubsystemOnRenderFinished
---@field ActiveExecutor UMoviePipelineExecutorBase
---@field CurrentQueue UMoviePipelineQueue
local UMoviePipelineQueueEngineSubsystem = {}

---@param InProgressWidgetClass TSubclassOf<UMovieRenderDebugWidget>
---@param bRenderPlayerViewport boolean
function UMoviePipelineQueueEngineSubsystem:SetConfiguration(InProgressWidgetClass, bRenderPlayerViewport) end
---@param InExecutor UMoviePipelineExecutorBase
function UMoviePipelineQueueEngineSubsystem:RenderQueueWithExecutorInstance(InExecutor) end
---@param InExecutorType TSubclassOf<UMoviePipelineExecutorBase>
---@return UMoviePipelineExecutorBase
function UMoviePipelineQueueEngineSubsystem:RenderQueueWithExecutor(InExecutorType) end
---@param InJob UMoviePipelineExecutorJob
function UMoviePipelineQueueEngineSubsystem:RenderJob(InJob) end
---@return boolean
function UMoviePipelineQueueEngineSubsystem:IsRendering() end
---@return UMoviePipelineQueue
function UMoviePipelineQueueEngineSubsystem:GetQueue() end
---@return UMoviePipelineExecutorBase
function UMoviePipelineQueueEngineSubsystem:GetActiveExecutor() end
---@param InSequence ULevelSequence
---@return UMoviePipelineExecutorJob
function UMoviePipelineQueueEngineSubsystem:AllocateJob(InSequence) end


---@class UMoviePipelineRenderPass : UMoviePipelineSetting
local UMoviePipelineRenderPass = {}


---@class UMoviePipelineSetting : UObject
---@field CachedPipeline TWeakObjectPtr<UMoviePipeline>
---@field bEnabled boolean
local UMoviePipelineSetting = {}

---@param bInEnabled boolean
function UMoviePipelineSetting:SetIsEnabled(bInEnabled) end
---@return boolean
function UMoviePipelineSetting:IsEnabled() end
---@param InOutUnrealURLParams TArray<FString>
---@param InOutCommandLineArgs TArray<FString>
---@param InOutDeviceProfileCvars TArray<FString>
---@param InOutExecCmds TArray<FString>
function UMoviePipelineSetting:BuildNewProcessCommandLineArgs(InOutUnrealURLParams, InOutCommandLineArgs, InOutDeviceProfileCvars, InOutExecCmds) end
---@param InOutUnrealURLParams FString
---@param InOutCommandLineArgs FString
function UMoviePipelineSetting:BuildNewProcessCommandLine(InOutUnrealURLParams, InOutCommandLineArgs) end


---@class UMoviePipelineSetting_BlueprintBase : UMoviePipelineSetting
---@field CategoryText FText
---@field bIsValidOnPrimary boolean
---@field bIsValidOnShots boolean
---@field bCanBeDisabled boolean
local UMoviePipelineSetting_BlueprintBase = {}

---@param InPipeline UMoviePipeline
function UMoviePipelineSetting_BlueprintBase:ReceiveTeardownForPipelineImpl(InPipeline) end
---@param InPipeline UMoviePipeline
function UMoviePipelineSetting_BlueprintBase:ReceiveSetupForPipelineImpl(InPipeline) end
---@param InOutFormatArgs FMoviePipelineFormatArgs
---@return FMoviePipelineFormatArgs
function UMoviePipelineSetting_BlueprintBase:ReceiveGetFormatArguments(InOutFormatArgs) end
function UMoviePipelineSetting_BlueprintBase:OnEngineTickBeginFrame() end


---@class UMoviePipelineShotConfig : UMoviePipelineConfigBase
local UMoviePipelineShotConfig = {}


---@class UMoviePipelineVideoOutputBase : UMoviePipelineOutputBase
local UMoviePipelineVideoOutputBase = {}


---@class UMoviePipelineViewFamilySetting : UMoviePipelineSetting
local UMoviePipelineViewFamilySetting = {}


---@class UMovieRenderDebugWidget : UUserWidget
local UMovieRenderDebugWidget = {}

---@param ForPipeline UMoviePipeline
function UMovieRenderDebugWidget:OnInitializedForPipeline(ForPipeline) end


